;-----------------------------------------------------------------------------
; DES test code - part of the DESPICable distribution
; Copyright 1994, 1996, 1997, 1998, 1999 Eric L. Smith
;
; WARNING: This software may be subject to export controls
;
; http://www.brouhaha.com/~eric/pic/
; http://www.brouhaha.com/~eric/crypto/
;
; DESPICable is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License version 2 as published by
; the Free Software Foundation.  Note that I am not granting permission to
; redistribute or modify DESPICable under the terms of any later version of
; the General Public License.
;
; This program is distributed in the hope that it will be useful (or at least
; amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
; Public License for more details.
;
; You should have received a copy of the GNU General Public License along with
; this program (in the file "COPYING"); if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; $Id: destest.asm,v 1.4 1999/05/07 01:57:31 eric Exp $
;-----------------------------------------------------------------------------

	processor	16f84

        radix           dec

;        errorlevel      -224
;        errorlevel      -305

; This test program is only intended for use on the PSIM simulator.
#define simulator

; To get cycle counts from PSIM, uncomment the following define
;#define benchmark


; For the Rivest test, it is necessary that calls to setkey not alter
; the original key value, since it will also be used as either plaintext
; or ciphertext.
#define preserve_key


;-----------------------------------------------------------------------------
; register and bit definitions common to all midrange PICs
;-----------------------------------------------------------------------------

w	equ	0
f	equ	1

indf	equ	0x00
tmr0	equ	0x01
pcl	equ	0x02
status	equ	0x03
fsr	equ	0x04
porta	equ	0x05
portb	equ	0x06
pclath	equ	0x0a

optreg	equ	0x81
trisa	equ	0x85
trisb	equ	0x86

; bits in status register

irp    equ	 7
rp1    equ	 6
rp0    equ	 5
to     equ	 4
pd     equ	 3
z      equ	 2
dc     equ	 1
c      equ	 0

; bits in option register

rbpu   equ	 7
intedg equ	 6
t0cs   equ	 5
t0se   equ	 4
psa    equ	 3
ps2    equ	 2
ps1    equ	 1
ps0    equ	 0

	
;-----------------------------------------------------------------------------
; memory map
;-----------------------------------------------------------------------------

rambase	equ	0x0c
rombase	equ	0x000


;-----------------------------------------------------------------------------
; ASCII characters
;-----------------------------------------------------------------------------

cr	equ	0x0d
lf	equ	0x0a


;-----------------------------------------------------------------------------
; macros for special PSIM instructions
;-----------------------------------------------------------------------------

	ifdef simulator
output	macro			; output a character to simulator console
	data	0x00b
	endm
	endif


	ifdef simulator
	ifdef benchmark
mark	macro			; output cycle count to simulator console
	data	0x00c
	endm
	else
mark	macro
	endm
	endif
	endif


halt	macro
	goto	$
	endm


;-----------------------------------------------------------------------------
; RAM definitions
;-----------------------------------------------------------------------------

	cblock	rambase

	tdata: 8
	temp		; very temporary, used in outhb
	bcount		; byte count used in outhexram
	count

	tot_vec
	good_enc
	bad_enc
	good_dec
	bad_dec

	endc



;-----------------------------------------------------------------------------
; vectors
;-----------------------------------------------------------------------------

	org	rombase

	goto	reset
	nop
	nop
	nop
	goto	reset


;-----------------------------------------------------------------------------
; message table
;-----------------------------------------------------------------------------

message_page	equ	$>>8

msgtab:  addwf   PCL

banner  equ     $-(msgtab+1)
        dt      cr,lf,"DES for PIC",cr,lf
	dt	"Copyright 1994, 1996, 1997, 1998 Eric Smith"
crlf	equ     $-(msgtab+1)
	dt	cr,lf,0
donemsg	equ     $-(msgtab+1)
	dt	"Test completed.  Total vectors: ",0
encmsg	equ     $-(msgtab+1)
	dt	"Encryptions ",0
decmsg	equ     $-(msgtab+1)
	dt	"Decryptions ",0
pcntmsg	equ     $-(msgtab+1)
	dt	"passed: ",0
fcntmsg	equ     $-(msgtab+1)
	dt	", failed: ",0
passmsg	equ     $-(msgtab+1)
	dt	"  pass",0
failmsg	equ     $-(msgtab+1)
	dt	"  FAIL!!!  Should be: ",0
keymsg	equ     $-(msgtab+1)
        dt      "Key:         ",0
plaintextmsg	equ     $-(msgtab+1)
        dt      "Plaintext:   ", 0
ciphertextmsg	equ     $-(msgtab+1)
	dt	"Ciphertext:  ", 0
imsg	equ     $-(msgtab+1)
	dt	"i: ", 0
ximsg	equ	$-(msgtab+1)
	dt	"  Xi: ", 0

        if      (msgtab>>8)!=($>>8)
        error   "messages must reside within a single page"
        endif

;-----------------------------------------------------------------------------
; test vectors
;-----------------------------------------------------------------------------

	include	"testvec.inc"


;-----------------------------------------------------------------------------
; utility functions
;-----------------------------------------------------------------------------

print_key:
	movlw	keymsg
	call	msgout
	movlw	keylen
	movwf	bcount
	call	outhexram
        movlw   -keylen
        addwf   fsr
	return


print_plaintext:
	movlw	plaintextmsg
	goto	print_text

print_ciphertext:
	movlw	ciphertextmsg

print_text:
	call	msgout
print_block:
	movlw	blocklen
	movwf	bcount
	call	outhexram
        movlw   -blocklen
        addwf   fsr
	return


outhexram:
	movf	indf,w
	call	outhb
	incf	fsr
	decfsz	bcount
	goto	outhr1
	return
outhr1:	movlw	'.'
	call	xmit
	goto	outhexram


;-----------------------------------------------------------------------------
; output a byte in hexadecimal
; uses temp
;-----------------------------------------------------------------------------

outhb:  movwf   temp
outhb1: swapf   temp,w
        call    outhd
        movf    temp,w

; fall into outhd

;-----------------------------------------------------------------------------
; output a hex digit
;-----------------------------------------------------------------------------

outhd:  andlw   0x0f
        addlw   0xf6
        btfsc   status,c
        addlw   0x07
        addlw   0x3a

; fall into xmit

;-----------------------------------------------------------------------------
; serial transmit character
;-----------------------------------------------------------------------------

xmit:	output			; works for simulator only
	return


;-----------------------------------------------------------------------------
; message output subroutine
;-----------------------------------------------------------------------------

msgout: movwf   temp
        movlw   message_page
        movwf   pclath
msglp:  movf    temp,w
        call    msgtab
        xorlw   0
        btfsc   status,z
        return
        call    xmit
        incf    temp
        goto    msglp


;-----------------------------------------------------------------------------
; initialization code
;-----------------------------------------------------------------------------

reset:
        movlw   0xff            ; all port pins are inputs (or inactive
        tris    porta           ; open-drain outputs)
        tris    portb
        clrf    porta
        clrf    portb

	clrf	tot_vec
	clrf	good_enc
	clrf	bad_enc
	clrf	good_dec
	clrf	bad_dec
	
	movlw	banner
	call	msgout
	

;-----------------------------------------------------------------------------
; main loop
;-----------------------------------------------------------------------------

main:	call	init_test_vec

loop:	incf	tot_vec

	movlw   tdata
	movwf   fsr

	call    get_test_vec_key
	call	print_key
	movlw	crlf
	call	msgout
	
	mark
	call    setkey
	mark

	call    get_test_vec_block
	call	print_plaintext
	movlw	crlf
	call	msgout
	
	mark
	call    des
	mark

	call	print_ciphertext
	
	call    compare_test_vec_block
	btfss	status,z
	goto	enc_fail

	incf	good_enc
	movlw	passmsg
	call	msgout
	movlw	crlf
	call	msgout
	goto	do_dec

enc_fail:
	incf	bad_enc
	movlw	failmsg
	call	msgout

	call	backup_test_vec_block
	call	get_test_vec_block
	call	print_block
	movlw	crlf
	call	msgout

do_dec:
	mark
	call	desinv
	mark

	call	print_plaintext

	call	backup_test_vec_block
	call	backup_test_vec_block
	call    compare_test_vec_block
	btfss	status,z
	goto	dec_fail

	incf	good_dec
	movlw	passmsg
	call	msgout
	movlw	crlf
	call	msgout
	goto	do_next

dec_fail:
	incf	bad_dec
	movlw	failmsg
	call	msgout

	call	backup_test_vec_block
	call	get_test_vec_block
	call	print_block
	movlw	crlf
	call	msgout
	
do_next:
	call	skip_test_vec_block
	movlw	crlf
	call	msgout
	
	movlw	crlf
	call	msgout

	call	end_of_test_vec
	btfss   status,z
	goto    loop
	
	movlw	donemsg
	call	msgout
	movf	tot_vec,w
	call	outhb
	movlw	crlf
	call	msgout

	movlw	encmsg
	call	msgout
	movlw	pcntmsg
	call	msgout
	movf	good_enc,w
	call	outhb
	movlw	fcntmsg
	call	msgout
	movf	bad_enc,w
	call	outhb
	movlw	crlf
	call	msgout
	
	movlw	decmsg
	call	msgout
	movlw	pcntmsg
	call	msgout
	movf	good_dec,w
	call	outhb
	movlw	fcntmsg
	call	msgout
	movf	bad_dec,w
	call	outhb
	movlw	crlf
	call	msgout
	
;-----------------------------------------------------------------------------
; Rivest's test
;	http://theory.lcs.mit.edu/~rivest/destest.txt
;-----------------------------------------------------------------------------

rivest_test_iteration_count	equ	16

; set up initial value

	movlw	0x94
	movwf	tdata+0
	movlw	0x74
	movwf	tdata+1
	movlw	0xb8
	movwf	tdata+2
	movlw	0xe8
	movwf	tdata+3
	movlw	0xc7
	movwf	tdata+4
	movlw	0x3b
	movwf	tdata+5
	movlw	0xca
	movwf	tdata+6
	movlw	0x7d
	movwf	tdata+7

	movlw	tdata
	movwf	fsr

	clrf	count

rivest_test_loop:

; output i and Xi
	movlw	imsg
	call	msgout

	movf	count,w
	call	outhb

	movlw	ximsg
	call	print_text

	movlw	crlf
	call	msgout

	movf	count,w
	xorlw	rivest_test_iteration_count
	btfsc	status,z
	goto	rivest_test_done

; do one DES or inverse DES

	call	setkey

	btfss	count,0
	call	des

	btfsc	count,0
	call	desinv

	incf	count
	goto	rivest_test_loop


rivest_test_done:

	halt


;-----------------------------------------------------------------------------
; don't forget to include the actual DES code and S-boxes
;-----------------------------------------------------------------------------

        include "des.inc"

	end
