;-----------------------------------------------------------------------------
; DESPICable - DES (FIPS PUB 46, ANSI X3.92-1981) for the PIC16Cxx
; Copyright 1994, 1996, 1997, 1998, 1999 Eric L. Smith
;
; WARNING: This software may be subject to export controls
;
; http://www.brouhaha.com/~eric/pic/
; http://www.brouhaha.com/~eric/crypto/
;
; DESPICable is free software; you can redistribute it and/or modify it
; under the terms of the GNU General Public License version 2 as published by
; the Free Software Foundation.  Note that I am not granting permission to
; redistribute or modify DESPICable under the terms of any later version of
; the General Public License.
;
; This program is distributed in the hope that it will be useful (or at least
; amusing), but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
; Public License for more details.
;
; You should have received a copy of the GNU General Public License along with
; this program (in the file "COPYING"); if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; $Id: des.inc,v 1.3 1999/05/07 01:57:31 eric Exp $
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
; parameters
;-----------------------------------------------------------------------------

; Don't assume that just because keylen, blocklen, and rounds are
; defined as constants, that you can change them arbitrarily and
; expect the code to still work.  It's mostly hard-coded.

keylen		equ	8
blocklen	equ	8
rounds		equ	16


;-----------------------------------------------------------------------------
; RAM definitions
;-----------------------------------------------------------------------------

        cblock
	keyl:   4
	keyr:   4

	left:   4
	right:  4
	newr:   4
        endc


;-----------------------------------------------------------------------------
; bit definitions
;-----------------------------------------------------------------------------

#define k01 keyl+0,7
#define k02 keyl+0,6
#define k03 keyl+0,5
#define k04 keyl+0,4
#define k05 keyl+0,3
#define k06 keyl+0,2
#define k07 keyl+0,1
#define k08 keyl+0,0
#define k09 keyl+1,7
#define k10 keyl+1,6
#define k11 keyl+1,5
#define k12 keyl+1,4
#define k13 keyl+1,3
#define k14 keyl+1,2
#define k15 keyl+1,1
#define k16 keyl+1,0
#define k17 keyl+2,7
#define k18 keyl+2,6
#define k19 keyl+2,5
#define k20 keyl+2,4
#define k21 keyl+2,3
#define k22 keyl+2,2
#define k23 keyl+2,1
#define k24 keyl+2,0
#define k25 keyl+3,7
#define k26 keyl+3,6
#define k27 keyl+3,5
#define k28 keyl+3,4

#define k29 keyr+0,7
#define k30 keyr+0,6
#define k31 keyr+0,5
#define k32 keyr+0,4
#define k33 keyr+0,3
#define k34 keyr+0,2
#define k35 keyr+0,1
#define k36 keyr+0,0
#define k37 keyr+1,7
#define k38 keyr+1,6
#define k39 keyr+1,5
#define k40 keyr+1,4
#define k41 keyr+1,3
#define k42 keyr+1,2
#define k43 keyr+1,1
#define k44 keyr+1,0
#define k45 keyr+2,7
#define k46 keyr+2,6
#define k47 keyr+2,5
#define k48 keyr+2,4
#define k49 keyr+2,3
#define k50 keyr+2,2
#define k51 keyr+2,1
#define k52 keyr+2,0
#define k53 keyr+3,7
#define k54 keyr+3,6
#define k55 keyr+3,5
#define k56 keyr+3,4

#define r01 right+0,7
#define r02 right+0,6
#define r03 right+0,5
#define r04 right+0,4
#define r05 right+0,3
#define r06 right+0,2
#define r07 right+0,1
#define r08 right+0,0
#define r09 right+1,7
#define r10 right+1,6
#define r11 right+1,5
#define r12 right+1,4
#define r13 right+1,3
#define r14 right+1,2
#define r15 right+1,1
#define r16 right+1,0
#define r17 right+2,7
#define r18 right+2,6
#define r19 right+2,5
#define r20 right+2,4
#define r21 right+2,3
#define r22 right+2,2
#define r23 right+2,1
#define r24 right+2,0
#define r25 right+3,7
#define r26 right+3,6
#define r27 right+3,5
#define r28 right+3,4
#define r29 right+3,3
#define r30 right+3,2
#define r31 right+3,1
#define r32 right+3,0

#define nr01 newr+0,7
#define nr02 newr+0,6
#define nr03 newr+0,5
#define nr04 newr+0,4
#define nr05 newr+0,3
#define nr06 newr+0,2
#define nr07 newr+0,1
#define nr08 newr+0,0
#define nr09 newr+1,7
#define nr10 newr+1,6
#define nr11 newr+1,5
#define nr12 newr+1,4
#define nr13 newr+1,3
#define nr14 newr+1,2
#define nr15 newr+1,1
#define nr16 newr+1,0
#define nr17 newr+2,7
#define nr18 newr+2,6
#define nr19 newr+2,5
#define nr20 newr+2,4
#define nr21 newr+2,3
#define nr22 newr+2,2
#define nr23 newr+2,1
#define nr24 newr+2,0
#define nr25 newr+3,7
#define nr26 newr+3,6
#define nr27 newr+3,5
#define nr28 newr+3,4
#define nr29 newr+3,3
#define nr30 newr+3,2
#define nr31 newr+3,1
#define nr32 newr+3,0


;-----------------------------------------------------------------------------
; DES encrypt one block of data
; 
; on entry:
;   FSR points to plaintext
; on exit:
;   FSR unchanged, points to ciphertext
;   PCLATH altered
;   temp altered
;-----------------------------------------------------------------------------

des:
        movlw   sboxpage	; set up to call s-boxes
        movwf   pclath
	call	ip
	call	descore
        goto    ipinv


;-----------------------------------------------------------------------------
; DES decrypt one block of data
; 
; on entry:
;   FSR points to plaintext
; on exit:
;   FSR unchanged, points to ciphertext
;   PCLATH altered
;   temp altered
;-----------------------------------------------------------------------------

desinv:
        movlw   sboxpage	; set up to call s-boxes
        movwf   pclath
	call	ip
	call	desinvcore
        goto    ipinv


;-----------------------------------------------------------------------------
; setkey: permute key
; on entry:
;   FSR points to (unpermuted) key
; on exit:
;   permuted key is in keyl:keyr
;   temp altered
;   FSR is unchanged, but memory pointed to by FSR will be altered
;     unless preserve_key is defined.  preserve_key costs 32 extra
;     clock cycles
;-----------------------------------------------------------------------------

setkey:	movlw	keylen
	movwf	temp

setkey0:
	ifdef	preserve_key
	movf	indf,w
	movwf	newr+0
	endif

        rlf     indf
	rrf	keyl+0
        rlf     indf
	rrf	keyl+1
        rlf     indf
	rrf	keyl+2
        rlf     indf
	rrf	keyl+3
        rlf     indf
	rrf	keyr+2
        rlf     indf
	rrf	keyr+1
        rlf     indf
	rrf	keyr+0

	ifdef	preserve_key
	movf	newr+0,w
	movwf	indf
	endif

        incf    fsr
	decfsz	temp
	goto	setkey0

        swapf   keyl+3,w        ; move low 4 bits of keyl+3
	movwf	keyr+3		;   into high 4 bits of keyr+3

	movlw	0f0h		; mask off extra bits
	andwf	keyl+3
	andwf	keyr+3

        movlw   -keylen		; restore FSR to original value
        addwf   fsr
	return



;-----------------------------------------------------------------------------
; initial permutation
;
; on entry:
;   data pointed to by FSR
; on exit:
;   permuted data in left:right
;   FSR unchanged
;   input data unchanged
;-----------------------------------------------------------------------------

ip:	movlw	blocklen
	movwf	temp

ip0:    rrf     indf
	rrf	left+3
        rrf     indf
	rrf	left+7
        rrf     indf
	rrf	left+2
        rrf     indf
	rrf	left+6
        rrf     indf
	rrf	left+1
        rrf     indf
	rrf	left+5
        rrf     indf
	rrf	left+0
        rrf     indf
	rrf	left+4

        incf    fsr
	decfsz	temp
	goto	ip0

        movlw   -blocklen	; restore FSR to original value
        addwf   fsr

	return


;-----------------------------------------------------------------------------
; inverse initial permutation

; on entry:
;   data in left:right
;   pointer to storage for permuted data output pointed to by FSR
; on exit:
;   permuted data output in buffer pointed to by FSR
;   FSR unchanged
;   input data unchanged
;-----------------------------------------------------------------------------

ipinv:
	movlw	blocklen
	movwf	temp

ipinv0:
	rrf	left+3
        rrf     indf
	rrf	left+7
        rrf     indf
	rrf	left+2
        rrf     indf
	rrf	left+6
        rrf     indf
	rrf	left+1
        rrf     indf
	rrf	left+5
        rrf     indf
	rrf	left+0
        rrf     indf
	rrf	left+4
        rrf     indf

        incf    fsr
	decfsz	temp
	goto	ipinv0

        movlw   -blocklen	; restore FSR to original value
        addwf   fsr

	return


;-----------------------------------------------------------------------------
; core of DES
;-----------------------------------------------------------------------------

; The descore and desinvcore subroutines do complete DES encryptions and
; decryptions less the initial permutation and inverse initial permutation.
; The permutations are omitted here because in a triple-DES, it is a waste
; of time to apply them to the intermediate stages.


; On entry:
;   plaintext in left:right
;   permuted key in keyl:keyr
; On exit:
;   ciphertext in left:right

;                             call =    2 cycles
;   4 calls to roundl @ 320 cycles = 1280 cycles
; 12 calls to roundl2 @ 338 cycles = 4056 cycles
;                 fall into swaplr =   18 cycles
;                                    -----------
;                            total = 5356 cycles

descore:
	call	roundl		; round 1
	call	roundl		; round 2
	call	roundl2		; round 3
	call	roundl2		; round 4
	call	roundl2		; round 5
	call	roundl2		; round 6
	call	roundl2		; round 7
	call	roundl2		; round 8
	call	roundl		; round 9
	call	roundl2		; round 10
	call	roundl2		; round 11
	call	roundl2		; round 12
	call	roundl2		; round 13
	call	roundl2		; round 14
	call	roundl2		; round 15
	call	roundl		; round 16

; swaplr = 20 cycles including call
swaplr:
        movf    left+0,w
	movwf	right+0
        movf    left+1,w
	movwf	right+1
        movf    left+2,w
	movwf	right+2
        movf    left+3,w
	movwf	right+3

        movf    newr+0,w
	movwf	left+0
        movf    newr+1,w
	movwf	left+1
        movf    newr+2,w
	movwf	left+2
        movf    newr+3,w
	movwf	left+3

	return


; On entry:
;   ciphertext in left:right
;   permuted key in keyl:keyr
; On exit:
;   plaintext in left:right

;                             call =    2 cycles
;   4 calls to roundr @ 324 cycles = 1296 cycles
; 12 calls to roundr2 @ 344 cycles = 4128 cycles
;                      goto swaplr =   20 cycles
;                                    -----------
;                            total = 5446 cycles

desinvcore:
	call	roundr		; round 1
	call	roundr2		; round 2
	call	roundr2		; round 3
	call	roundr2		; round 4
	call	roundr2		; round 5
	call	roundr2		; round 6
	call	roundr2		; round 7
	call	roundr		; round 8
	call	roundr2		; round 9
	call	roundr2		; round 10
	call	roundr2		; round 11
	call	roundr2		; round 12
	call	roundr2		; round 13
	call	roundr2		; round 14
	call	roundr		; round 15
	call	roundr		; round 16

	goto	swaplr


;-----------------------------------------------------------------------------
; key rotation subroutines
;-----------------------------------------------------------------------------

; The 16 rounds of the DES each use a different 48-bit subkey, which is
; generated by independently rotating the two 28-bit halves of the 56-bit key,
; then using Permuted Choice 2 to extract the 48 bit subkey.
;
; Since the PIC doesn't have enough RAM to store precomputed subkeys, the
; rotations are done on the fly using these subroutines.  The Permuted Choice
; 2 function is done as part of the xorkey macro calls.


; On entry and exit, the current subkey is in keyl:keyr.

; keyrotl takes 18 cycles including call

keyrotl:
        bcf     status,c
	rlf	keyl+3
	rlf	keyl+2
	rlf	keyl+1
	rlf	keyl+0
        btfsc   status,c
	bsf	k28

        bcf     status,c
	rlf	keyr+3
	rlf	keyr+2
	rlf	keyr+1
	rlf	keyr+0
        btfsc   status,c
	bsf	k56

	return


; keyrotr takes 20 cycles including call

keyrotr:
        bcf     status,c
	rrf	keyl+0
	rrf	keyl+1
	rrf	keyl+2
	rrf	keyl+3
	btfsc	keyl+3,3
	bsf	k01
	bcf	keyl+3,3

        bcf     status,c
	rrf	keyr+0
	rrf	keyr+1
	rrf	keyr+2
	rrf	keyr+3
	btfsc	keyr+3,3
	bsf	k29
	bcf	keyr+3,3

	return


;-----------------------------------------------------------------------------
; DES round macros
;-----------------------------------------------------------------------------

; The gethi and getlo macros implement six bit sections of the Expansion
; Permutation.

; 6 cycles
gethi   macro   rbyte,b20r,b20b,b10r,b10b
        swapf   rbyte,w
        andlw   0x0f
        btfsc   b20r,b20b
        iorlw   0x20
        btfsc   b10r,b10b
        iorlw   0x10
	endm

; 6 cycles
getlo   macro   rbyte,b20r,b20b,b10r,b10b
        movf    rbyte,w
        andlw   0x0f
        btfsc   b20r,b20b
        iorlw   0x20
        btfsc   b10r,b10b
        iorlw   0x10
	endm

; The xorkey macro is used to exclusive-or the 6-bit result of the Expansion
; Permuation in the W register (as generated by the gethi or getlo macros
; above) with the appropriate 6 bits of the current subkey (as defined by
; Permuted Choice 2).  The arguments are the six subkey bits to be used.

; 12 cycles
xorkey  macro   b20r,b20b,b10r,b10b,b08r,b08b,b04r,b04b,b02r,b02b,b01r,b01b
        btfsc   b20r,b20b
        xorlw   0x20
        btfsc   b10r,b10b
        xorlw   0x10
        btfsc   b08r,b08b
        xorlw   0x08
        btfsc   b04r,b04b
        xorlw   0x04
        btfsc   b02r,b02b
        xorlw   0x02
        btfsc   b01r,b01b
        xorlw   0x01
	endm

; The corehi and corelo macros are used to perform the S-box lookup and
; the P-box permutation.    The only difference between the two macros is
; which half of the sbox table value is used.  The corehi macro must be
; used for S-boxes 1, 3, 5, and 7, while the corelo macro must be used for
; S-boxes 2, 4, 6, and 8.

; The first argument to the macro is the entry point of the S-box table to
; be used.

; The second through fifth arguments to the macro are the bits that the
; P-box permutes the S-box outputs into, in order from the most to the least
; significant.

; 15 cycles for sbox12
; 16 cycles for others
corehi  macro   sbox,b7r,b7b,b6r,b6b,b5r,b5b,b4r,b4b
	call	sbox			; 6 cycles for sbox12,
					; 7 cycles for others
	movwf	temp
	btfsc	temp,7
        bsf     b7r,b7b
	btfsc	temp,6
        bsf     b6r,b6b
	btfsc	temp,5
        bsf     b5r,b5b
	btfsc	temp,4
        bsf     b4r,b4b
	endm

; 15 cycles for sbox12
; 16 cycles for others
corelo  macro   sbox,b3r,b3b,b2r,b2b,b1r,b1b,b0r,b0b
	call	sbox			; 6 cycles for sbox12,
					; 7 cycles for others
	movwf	temp
	btfsc	temp,3
        bsf     b3r,b3b
	btfsc	temp,2
        bsf     b2r,b2b
	btfsc	temp,1
        bsf     b1r,b1b
	btfsc	temp,0
        bsf     b0r,b0b
	endm


;-----------------------------------------------------------------------------
; one round of DES (with various key rotations)
;-----------------------------------------------------------------------------

; roundr2 = 344 cycles
; roundr  = 324 cycles

roundr2:
	call	round
	call	keyrotr		; 20 cycles
	goto	keyrotr		; 20 cycles

roundr:
	call	round		; 302 cycles
	goto	keyrotr		;  20 cycles

; roundl2 = 338 cycles including call
; roundl  = 320 cycles including call

roundl2:
	call	keyrotl		; 18 cycles
roundl:
	call	keyrotl		; 18 cycles
; fall into round


; xxx cycles including call
;                 call =   2 cycles
;           clear newr =   4 cycles
; 2 sboxes @ 33 cycles =  66 cycles
; 6 sboxes @ 34 cycles = 204 cycles
;                  xor =   8 cycles
;                 swap =  16 cycles
;               return =   2 cycles
;                        ----------
;                total = 302 cycles

round:
; clear newr to make it easy to do the P-box permutation (by simply setting
; bits)
	clrf	newr+0
	clrf	newr+1
	clrf	newr+2
	clrf	newr+3	

; do s-box 1
	gethi	right+0,r32,r05			; 6 cycles
	xorkey	k14,k05,k17,k11,k24,k01		; 12 cycles
	corehi	sbox12,nr09,nr17,nr23,nr31	; 15 cycles

; do s-box 2
	getlo	right+0,r04,r09			; 6 cycles
	xorkey	k03,k10,k28,k15,k06,k21		; 12 cycles
	corelo	sbox12,nr13,nr28,nr02,nr18	; 15 cycles

; do s-box 3
	gethi	right+1,r08,r13			; 6 cycles
	xorkey	k23,k08,k19,k12,k04,k26		; 12 cycles
	corehi	sbox34,nr24,nr16,nr30,nr06	; 16 cycles

; do s-box 4
	getlo	right+1,r12,r17			; 6 cycles
	xorkey	k16,k02,k07,k27,k20,k13		; 12 cycles
	corelo	sbox34,nr26,nr20,nr10,nr01	; 16 cycles

; do s-box 5
	gethi	right+2,r16,r21			; 6 cycles
	xorkey	k41,k55,k52,k31,k37,k47		; 12 cycles
	corehi	sbox56,nr08,nr14,nr25,nr03	; 16 cycles

; do s-box 6
	getlo	right+2,r20,r25			; 6 cycles
	xorkey	k30,k48,k40,k51,k45,k33		; 12 cycles
	corelo	sbox56,nr04,nr29,nr11,nr19	; 16 cycles

; do s-box 7
	gethi	right+3,r24,r29			; 6 cycles
	xorkey	k44,k53,k49,k39,k56,k34		; 12 cycles
	corehi	sbox78,nr32,nr12,nr22,nr07	; 16 cycles

; do s-box 8
	getlo	right+3,r28,r01			; 6 cycles
	xorkey	k46,k32,k42,k50,k36,k29		; 12 cycles
	corelo	sbox78,nr05,nr27,nr15,nr21	; 16 cycles

; now exclusive-or the old left with the new right to complete the
; computation

        movf    left+0,w
	xorwf	newr+0
        movf    left+1,w
	xorwf	newr+1
        movf    left+2,w
	xorwf	newr+2
        movf    left+3,w
	xorwf	newr+3

; now swap the stuff around

        movf    right+0,w
	movwf	left+0
        movf    right+1,w
	movwf	left+1
        movf    right+2,w
	movwf	left+2
        movf    right+3,w
	movwf	left+3

        movf    newr+0,w
	movwf	right+0
        movf    newr+1,w
	movwf	right+1
        movf    newr+2,w
	movwf	right+2
        movf    newr+3,w
	movwf	right+3

	return


;-----------------------------------------------------------------------------
; s-box table lookup functions
;-----------------------------------------------------------------------------

; Because of the way they are accessed, all of the S-box data tables must
; reside within the same page of ROM.  Since the S-box data consumes
; exactly 256 words of memory, the actual entry points to the table lookup
; functions must be stored in a different page.  As usual on the midrange
; PIC processors, it is important that PCLATH be set to the correct page
; prior to calling the table lookup functions.

; 6 cycles including call
sbox12:
        movwf   pcl

; 7 cycles including call
sbox34:
	iorlw	040h
        movwf   pcl

; 7 cycles including call
sbox56:
	iorlw	080h
        movwf   pcl

; 7 cycles including call
sbox78:
	iorlw	0c0h
        movwf   pcl


;-----------------------------------------------------------------------------
; s-box data tables
;-----------------------------------------------------------------------------

        org     ($+0xff)&~0xff  ; force page alignment
sboxpage equ ($>>8)

; Since the output width of each S-box is four bits, each S-box table as
; stored in ROM contains two S-boxes; each data byte is split between the two
; with the most significant four bits of the byte storing the output of the
; lower numbered sbox.  For example, the most significant four bits of each
; byte of sbox12 are used to store S-box 1, and the least significant four
; bits are used to store S-box 2.

; S boxes one and two
        dt      0xef, 0x41, 0xd8, 0x1e, 0x26, 0xfb, 0xb3, 0x84
        dt      0x39, 0xa7, 0x62, 0xcd, 0x5c, 0x90, 0x05, 0x7a
        dt      0x03, 0xfd, 0x74, 0x47, 0xef, 0x22, 0xd8, 0x1e
        dt      0xac, 0x60, 0xc1, 0xba, 0x96, 0x59, 0x3b, 0x85
        dt      0x40, 0x1e, 0xe7, 0x8b, 0xda, 0x64, 0x2d, 0xb1
        dt      0xf5, 0xc8, 0x9c, 0x76, 0x39, 0xa3, 0x52, 0x0f
        dt      0xfd, 0xc8, 0x8a, 0x21, 0x43, 0x9f, 0x14, 0x72
        dt      0x5b, 0xb6, 0x37, 0xec, 0xa0, 0x05, 0x6e, 0xd9

; S boxes three and four
        dt      0xa7, 0x0d, 0x9e, 0xe3, 0x60, 0x36, 0xf9, 0x5a
        dt      0x11, 0xd2, 0xc8, 0x75, 0xbb, 0x4c, 0x24, 0x8f
        dt      0xdd, 0x78, 0x0b, 0x95, 0x36, 0x4f, 0x60, 0xa3
        dt      0x24, 0x87, 0x52, 0xec, 0xc1, 0xba, 0xfe, 0x19
        dt      0xda, 0x66, 0x49, 0x90, 0x8c, 0xfb, 0x37, 0x0d
        dt      0xbf, 0x11, 0x23, 0xce, 0x55, 0xa2, 0xe8, 0x74
        dt      0x13, 0xaf, 0xd0, 0x06, 0x6a, 0x91, 0x8d, 0x78
        dt      0x49, 0xf4, 0xe5, 0x3b, 0xbc, 0x57, 0x22, 0xce

; S boxes five and six
        dt      0x2c, 0xc1, 0x4a, 0x1f, 0x79, 0xa2, 0xb6, 0x68
        dt      0x80, 0x5d, 0x33, 0xf4, 0xde, 0x07, 0xe5, 0x9b
        dt      0xea, 0xbf, 0x24, 0xc2, 0x47, 0x7c, 0xd9, 0x15
        dt      0x56, 0x01, 0xfd, 0xae, 0x30, 0x9b, 0x83, 0x68
        dt      0x49, 0x2e, 0x1f, 0xb5, 0xa2, 0xd8, 0x7c, 0x83
        dt      0xf7, 0x90, 0xc4, 0x5a, 0x61, 0x3d, 0x0b, 0xe6
        dt      0xb4, 0x83, 0xc2, 0x7c, 0x19, 0xe5, 0x2f, 0xda
        dt      0x6b, 0xfe, 0x01, 0x97, 0xa6, 0x40, 0x58, 0x3d

; S boxes seven and eight
        dt      0x4d, 0xb2, 0x28, 0xe4, 0xf6, 0x0f, 0x8b, 0xd1
        dt      0x3a, 0xc9, 0x93, 0x7e, 0x55, 0xa0, 0x6c, 0x17
        dt      0xd1, 0x0f, 0xbd, 0x78, 0x4a, 0x93, 0x17, 0xa4
        dt      0xec, 0x35, 0x56, 0xcb, 0x20, 0xfe, 0x89, 0x62
        dt      0x17, 0x4b, 0xb4, 0xd1, 0xc9, 0x3c, 0x7e, 0xe2
        dt      0xa0, 0xf6, 0x6a, 0x8d, 0x0f, 0x53, 0x95, 0x28
        dt      0x62, 0xb1, 0xde, 0x87, 0x14, 0x4a, 0xa8, 0x7d
        dt      0x9f, 0x5c, 0x09, 0xf0, 0xe3, 0x25, 0x36, 0xcb
