/* Various utility functions */

// Initialize cavesel tree in the given order
void cavesel_tree_init(int order);

// Initialize locsel tree allowing (or not) intermediate items selection
void locsel_tree_init(int allow);

// Initialize authors lists
void init_authors(void);

// Updates combo popdown list with CD titles
void update_cds(GtkCombo *combo);

// Advance activity on appbar
void activity(void);

// Handle config data and initialize preferences window
int load_prefs(void);
int save_prefs(void);
void apply_prefs(void);
void restore_prefs(void);
Prefs *test_prefs(void);	// "saves" current prefs in a static buffer
void cancel_prefs(Prefs *);	// restores prefs from buffer

// Trims leading spaces from string
char *trim(char *);

// Append string to the end of the combo popup list
void combo_string_add(GtkCombo *combo, const char *string);

#define lw(widget, widget_name) lookup_widget(widget, widget_name)

#define DBG() printf("In file " __FILE__ " at line %d\n", __LINE__)
