/* Various utility functions */

#include <ctype.h>
#include <string.h>
#include <gnome.h>
#include <libpq-fe.h>

#include "support.h"
#include "globvars.h"
#include "interface.h"
#include "utility.h"
#include "db.h"

void activity(void)
{
 static int status=100;

 status= (status+1) % 100;
 gtk_progress_set_value(appbar_progress, status);
 gnome_appbar_refresh(appbar);
 while(gtk_events_pending())
  gtk_main_iteration_do(FALSE);
}

void update_cds(GtkCombo *combo)
{
 DBConn conn=db_connect();
 GList *cds=NULL;
 int cnt, nrows;

 nrows=db_exec(conn, "SELECT trim(cdid)  FROM cds WHERE closed='f' "
    		     "ORDER BY cdid");
 for(cnt=0; cnt<nrows; ++cnt) {
  cds=g_list_append(cds, db_getrow(conn, cnt, 0));
 }
 if(nrows) {
  gtk_combo_set_popdown_strings(combo, cds);
 }

 db_disconnect(conn);
}

static void create_tree_sort_name(DBConn conn,
				  gint parent,
				  GtkCTree *root,
				  GtkCTreeNode *pt)
{
 int cnt, nElems;

 nElems=db_exec(conn, "SELECT name, id FROM caves ORDER BY name");

 if(nElems) {
  char last[61], cur[61], *n[1];
  GtkCTreeNode *sti=NULL, *cti;
  int spn;

  strcpy(last, trim(db_getrow(conn, 0, 0)));
  spn= strcspn(last, " \t.,");

  activity();

  for(cnt=1; cnt<nElems; ++cnt) {
   strcpy(cur, trim(db_getrow(conn, cnt, 0)));
   if(!strncmp(last, cur, spn)) {	// Must go in the same subtree
    if(!sti) {	// Create subtree
     char buff[66];
     strncpy(buff, last, spn);
     buff[spn]=0;
     strcat(buff, " ...");
     n[0]=buff;
     sti=gtk_ctree_insert_node(root, pt, NULL, n, 0, NULL, NULL, NULL, NULL,
                               FALSE, TRUE);
     gtk_ctree_collapse(root, sti);
     gtk_ctree_node_set_selectable(root, sti, FALSE);
     gtk_ctree_node_set_row_data(root, sti, NULL);
    }
    n[0]=last;
    cti=gtk_ctree_insert_node(root, sti, NULL, n, 0, NULL, NULL, NULL, NULL,
                	      FALSE, TRUE);
   } else {
    n[0]=last;
    if(sti)
     cti=gtk_ctree_insert_node(root, sti, NULL, n, 0, NULL, NULL, NULL, NULL,
    		    	       FALSE, TRUE);
    else
     cti=gtk_ctree_insert_node(root, pt, NULL, n, 0, NULL, NULL, NULL, NULL,
                	       FALSE, TRUE);
    sti=NULL;
   }
   gtk_ctree_node_set_row_data(root, cti,
			 (gpointer)atoi(db_getrow(conn, cnt-1, 1)));
   strcpy(last, cur);
   spn= strcspn(last, " \t.,");
   activity();
  }
  n[0]=last;
  if(sti)
   cti=gtk_ctree_insert_node(root, sti, NULL, n, 0, NULL, NULL, NULL, NULL,
                	     FALSE, TRUE);
  else
   cti=gtk_ctree_insert_node(root, pt, NULL, n, 0, NULL, NULL, NULL, NULL,
                	     FALSE, TRUE);
  gtk_ctree_node_set_row_data(root, cti,
			(gpointer)atoi(db_getrow(conn, cnt-1, 1)));
 }
}

// Used by create_tree_sort_loc and locsel_tree_init
static int allow_intermediate_selection=0;

static void create_tree_sort_loc(DBConn conn,
				 gint parent,
				 GtkCTree *root,
				 GtkCTreeNode *pt)
{
 GtkCTreeNode *ti;
 char query[1024], *name[1];
 int cnt, nElems;

 sprintf(query, "DECLARE curs%d CURSOR FOR "
                "SELECT id, trim(descr) FROM locations WHERE parent=%d",
		parent, parent);
 if(!parent) // avoid infinite recursion
  strcat(query, " and id!=0");

 strcat(query, " ORDER BY descr");

 db_exec(conn, query);

 sprintf(query, "FETCH ALL IN curs%d", parent);
 nElems=db_exec(conn, query);
 if(nElems) {
  DBConn copy=db_dup(conn);	// Must keep a "local" DBConn !
  for(cnt=0; cnt < nElems; ++cnt) {
   name[0]=trim(db_getrow(conn, cnt, 1));
   ti=gtk_ctree_insert_node(root, pt, NULL, name, 0, NULL, NULL, NULL, NULL,
                            FALSE, TRUE);
   gtk_ctree_collapse(root, ti);
   if(!allow_intermediate_selection)
    gtk_ctree_node_set_selectable(root, pt, FALSE);
   gtk_ctree_node_set_row_data(root, ti,
                    (gpointer)atoi(db_getrow(conn, cnt, 0)));
   create_tree_sort_loc(copy,
                        atoi(db_getrow(conn, cnt, 0)),
			root,
			ti);
   activity();
  }
  db_undup(copy);
 }

 sprintf(query, "CLOSE curs%d", parent);
 db_exec(conn, query);
}

static void removenode(GtkCTree *t, GtkCTreeNode *n, gpointer d)
{
 gtk_ctree_remove_node(t, n);
 activity();
}

void locsel_tree_init(int allow_interm)
{
 GtkWidget *root=lw(locselect, "locselect_tree"); // Main tree
 GtkCTreeNode *rootnode;
 DBConn conn;

 // Must first remove selected items
 gtk_ctree_post_recursive(GTK_CTREE(root), NULL, removenode, NULL);

 conn=db_connect();
 if(conn) {		// Create tree
  char *rootname[1];
  db_exec(conn, "SELECT id, descr FROM locations WHERE id=0");
  rootname[0]=db_getrow(conn, 0, 1);
  rootnode=gtk_ctree_insert_node(GTK_CTREE(root), NULL, NULL, rootname, 0,
                                NULL, NULL, NULL, NULL, FALSE, TRUE);
  gtk_ctree_node_set_row_data(GTK_CTREE(root), rootnode,
                    (gpointer)atoi(db_getrow(conn, 0, 0)));
  allow_intermediate_selection=allow_interm;
  create_tree_sort_loc(conn, 0, GTK_CTREE(root), GTK_CTREE_NODE(rootnode));

  gtk_ctree_expand_to_depth(GTK_CTREE(root), GTK_CTREE_NODE(rootnode), 2);
 }
 db_disconnect(conn);

 gtk_widget_show(root);
}

void cavesel_tree_init(int order)
{
 static void (*create_tree[])(DBConn, gint, GtkCTree *, GtkCTreeNode *)={
    create_tree_sort_loc,
    create_tree_sort_name
 };
 GtkWidget *root=lw(caveselect, "cavesel_tree"); // Main tree
 GtkCTreeNode *rootnode;
 DBConn conn;

 // Must first remove selected items
 gtk_ctree_post_recursive(GTK_CTREE(root), NULL, removenode, NULL);


 conn=db_connect();
 if(conn) {		// Create tree
  char *rootname[1];
  db_exec(conn, "SELECT id, descr FROM locations WHERE id=0");
  rootname[0]=db_getrow(conn, 0, 1);
  rootnode=gtk_ctree_insert_node(GTK_CTREE(root), NULL, NULL, rootname, 0,
                                NULL, NULL, NULL, NULL, FALSE, TRUE);
  gtk_ctree_node_set_row_data(GTK_CTREE(root), rootnode,
                    (gpointer)atoi(db_getrow(conn, 0, 0)));

  allow_intermediate_selection=0;
  create_tree[order](conn, 0, GTK_CTREE(root), GTK_CTREE_NODE(rootnode));

  gtk_ctree_expand_to_depth(GTK_CTREE(root), GTK_CTREE_NODE(rootnode), 1);
 }
 db_disconnect(conn);

 gtk_widget_show(root);
}

// Preferences window handling
void apply_prefs(void)
{
 #define GETPREFS(v, t) strncpy(v, gtk_entry_get_text(GTK_ENTRY(\
    			 lw(preferences, "prefs_" t))), sizeof(v))
 GETPREFS(prefs.db.host, "db_host");
 GETPREFS(prefs.db.database, "db_db");
 GETPREFS(prefs.db.user, "db_user");
 GETPREFS(prefs.db.password, "db_passwd");
 GETPREFS(prefs.dirs.temp, "dir_tmp");
 GETPREFS(prefs.dirs.thumbs, "dir_thumbs");
 GETPREFS(prefs.dirs.cdrom, "dir_cdrom");
 GETPREFS(prefs.dirs.backup, "dir_backup");
 GETPREFS(prefs.sys.writer, "sys_cdwriter");
 #undef GETPREFS
}

void restore_prefs(void)
{
 #define SETPREFS(t, v) gtk_entry_set_text(GTK_ENTRY(\
			  lw(preferences, "prefs_" t)), v)
   
 SETPREFS("db_host", prefs.db.host);
 SETPREFS("db_db", prefs.db.database);
 SETPREFS("db_user", prefs.db.user);
 SETPREFS("db_passwd", prefs.db.password);
 SETPREFS("dir_tmp", prefs.dirs.temp);
 SETPREFS("dir_thumbs", prefs.dirs.thumbs);
 SETPREFS("dir_cdrom", prefs.dirs.cdrom);
 SETPREFS("dir_backup", prefs.dirs.backup);
 SETPREFS("sys_cdwriter", prefs.sys.writer);
 #undef SETPREFS
}

int save_prefs(void)
{
 FILE *f=fopen(RCFILE, "w");
 int wrote;

 if(!f) return 1;

 apply_prefs();
 wrote=fwrite(&prefs, sizeof(Prefs), 1, f);
 fclose(f);
 return(wrote != 1);
}

int load_prefs(void)
{
 FILE *f=fopen(RCFILE, "r");
 if(!f) {	// Not found: create config file
  if(save_prefs()) return 1; // Failed to create rc file: abort
 } else {
  if(1 == fread(&prefs, sizeof(Prefs), 1, f)) {
   restore_prefs();
  };
  fclose(f);
 };
 return 0;
}

Prefs *test_prefs(void)
{
 static Prefs tp;
 memcpy(&tp, &prefs, sizeof(Prefs));
 apply_prefs();
 return &tp;
}

void cancel_prefs(Prefs *tp)
{
 memcpy(&prefs, tp, sizeof(Prefs));
 apply_prefs();
}

char *trim(char *s)
{
 if(s) {
  char *t=s+strlen(s)-1;
  while(t>=s && isspace(*t))
   --t;
  *++t=0;
 }
 return s;
}

void init_authors(void)
{
 DBConn conn=db_connect();
 GList *authors=NULL;
 GtkCombo *search=GTK_COMBO(lw(diacatalog, "search_author_select")),
          *insert=GTK_COMBO(lw(diacatalog, "insert_author_select")),
	  *cd=GTK_COMBO(lw(newcd, "newcd_author_select"));
 int cnt, nrows;

 nrows=db_exec(conn, "SELECT trim(name)||' '||trim(surname) FROM authors "
            	     "ORDER BY name, surname");
 for(cnt=0; cnt<nrows; ++cnt) {
  authors=g_list_append(authors, db_getrow(conn, cnt, 0));
  activity();
 }
 if(nrows) {
  gtk_combo_set_popdown_strings(insert, authors);
  gtk_combo_set_popdown_strings(cd, authors);
  authors=g_list_prepend(authors, "");
  gtk_combo_set_popdown_strings(search, authors);
 }

 db_disconnect(conn);
}

void combo_string_add(GtkCombo *combo, const char *string)
{
 GList *scan;	// Scan items to find where to insert
 int cnt=0;	// Position counter
 GtkWidget *li=gtk_list_item_new_with_label(string);
 scan=GTK_LIST(combo->list)->children;
 while(scan &&
       strcmp(GTK_LABEL(GTK_BIN(scan->data)->child)->label, string)<0) {
  ++cnt;
  scan=scan->next;
 }
 gtk_list_insert_items(GTK_LIST(combo->list), g_list_append(NULL, li), cnt);
 gtk_widget_show(li);
}
