/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <libpq-fe.h>

#include "interface.h"
#include "support.h"
#include "globvars.h"
#include "utility.h"
#include "callbacks.h"

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gnome_init ("diacat", VERSION, argc, argv);

  diacatalog = create_diacatalog();
  preferences = create_preferences();
  if(load_prefs())
   exit(1);
  caveselect = create_caveselect();
  newcd = create_newcd();
  confirm_delete_all = create_confirm_delete_all();
  confirm_init_db = create_confirm_init_db();
  createdb_info=create_createdb_info();
  newcave=create_newcave();
  newloc=create_newloc();
  locselect=create_locselect();
  newauthor=create_newauthor();

  gtk_widget_show_now (diacatalog);

  // Initialize data structures
  gdk_window_set_cursor(lw(diacatalog, "preview_button")->window,
                        gdk_cursor_new(GDK_CIRCLE));
  gtk_widget_realize(lw(diacatalog, "preview_button"));

  appbar=GNOME_APPBAR(lw(diacatalog, "appbar1"));
  appbar_progress=gnome_appbar_get_progress(appbar);
  gtk_progress_configure(appbar_progress, 0, 0, 100);
  gtk_progress_set_activity_mode(appbar_progress, TRUE);

  // Initialize authors list
  init_authors();

  // Just to force a call to update_stats()
  gtk_notebook_set_page(GTK_NOTEBOOK(lw(diacatalog, "notebook1")), 1);
  gtk_notebook_set_page(GTK_NOTEBOOK(lw(diacatalog, "notebook1")), 0);

  // Search must start from the first available day :-)
  gnome_date_edit_set_time(GNOME_DATE_EDIT(lw(diacatalog, "search_from")), 1);

  // Autosort authors lists
//  gtk_clist_set_auto_sort(GTK_CLIST(GTK_COMBO(
//                                     lw(diacatalog, "search_author_select")
//				   )->list), TRUE);
//  gtk_clist_set_auto_sort(lw(diacatalog, "insert_author_select", TRUE));

  { // Allocate colors for results list
   #define BS gtk_widget_get_style(lw(diacatalog, "search_results"))
   #define INIT(idx, R, G, B) search_results_style[idx]= gtk_style_copy(BS);\
                              search_results_style[idx]->fg[GTK_STATE_NORMAL]=\
			       (GdkColor){0, R, G, B};

   INIT(RES_COLOR_MAX,		0,  49152,	0);	// Green
   INIT(RES_COLOR_HIGH,		0,	0,  65535);	// Blue
   INIT(RES_COLOR_MEDIUM,	0,	0,	0);	// Black
   INIT(RES_COLOR_LOW,	    65535,	0,	0);	// Red

   #undef INIT
   #undef BS
  }

  { // Make result list columns auto-resizeable
   GtkCList *l=GTK_CLIST(lw(diacatalog, "search_results"));
   gtk_clist_set_column_auto_resize(l, 0, TRUE);
   gtk_clist_set_column_auto_resize(l, 1, TRUE);
   gtk_clist_set_column_auto_resize(l, 2, TRUE);
   l=GTK_CLIST(lw(diacatalog, "createcd_files"));
   gtk_clist_set_column_auto_resize(l, 0, TRUE);
   gtk_clist_set_column_auto_resize(l, 1, TRUE);
   gtk_clist_set_column_justification(l, 1, GTK_JUSTIFY_RIGHT);
  }

  // Must manually connect signal for option menu
  gtk_signal_connect(
   GTK_OBJECT(GTK_OPTION_MENU(lw(caveselect, "cavesel_sort"))->menu),
   "deactivate",
   GTK_SIGNAL_FUNC(on_cavesel_sort_changed),
   NULL);

  gtk_main ();
  return 0;
}

