// Constants
#define RCFILE "/home/diego/.diacatrc.bin"

// Result list quality color codes
enum {
 RES_COLOR_MAX=0,
 RES_COLOR_HIGH,
 RES_COLOR_MEDIUM,
 RES_COLOR_LOW,
 RES_COLOR_LAST
};
 
// Cave selection tree order
// Do not change order : used as an array index in tree_init() !!!
enum {
 CAVESEL_ORD_LOC,
 CAVESEL_ORD_NAME
};

/* Data structures used */
typedef struct {
    struct {
	char host[41];
	char database[21];
	char user[21];
	char password[9];
    } db;
    struct {
	char temp[41];
	char thumbs[41];
	char cdrom[41];
	char backup[41];
    } dirs;
    struct {
	char writer[41];
    } sys;
} Prefs;

typedef struct {
 gint	ord;
 gint	rowcode;
} Cavesel;

typedef struct {
    gint	id;
    char	filename[128];
    gint	filesize;
} Current_preview;

typedef void *DBConn;

/* Shared variables declaration */

extern GtkWidget *diacatalog;	/* main program window, for lookup_widget */
extern GtkWidget *caveselect;	/* cave selection dialog */
extern GtkWidget *newcd;		/* new CD creation dialog */
extern GtkWidget *preferences;	/* preferences dialog */
extern GtkWidget *confirm_delete_all;	/* delete all files from cd ? */
extern GtkWidget *confirm_init_db;	/* create a new (empty) db ? */
extern GtkWidget *createdb_info;	/* create a new db progress */
extern GtkWidget *newcave;
extern GtkWidget *newloc;
extern GtkWidget *locselect;
extern GtkWidget *newauthor;

extern GnomeAppBar *appbar;	/* appbar (complete) */
extern GtkProgress *appbar_progress; /* appbar (just progress) */
extern GtkWidget *browse_result;     /* Where to put text from {cave|loc}sel */

extern Prefs prefs;
extern Current_preview current_preview;
extern Cavesel cavesel;

extern GtkStyle *search_results_style[RES_COLOR_LAST];
