// Connects to a database (Uses data from prefs)
DBConn	db_connect(void);

// Execute a query
int	db_exec(DBConn conn, const char *query);

// Fetch results one field at a time
char *	db_getrow(DBConn conn, int row, int col);

// Escapes a string to prevent errors when inserting
char *db_esc(char *);

// "Duplicate" an active connection
DBConn db_dup(DBConn conn);

// "Destroy" a duplicated connection
// No effect on the original connection
void db_undup(DBConn conn);

// Disconnect from a database
void	db_disconnect(DBConn conn);
