/* Various utility functions */

#include <ctype.h>
#include <string.h>
#include <gnome.h>
#include <libpq-fe.h>

#include "support.h"
#include "globvars.h"
#include "interface.h"
#include "utility.h"
#include "db.h"

//@@@ To be finished: connection duplication

// Reference count nel padre, impedire chiusura di connessioni in uso
typedef struct __DBConn {
    PGconn		*c;	// Connection
    PGresult		*r;	// Result
    struct __DBConn	*p;	// Original connection (parent)
} _DBConn;

DBConn db_connect(void)
{
 char connstr[1024];
 _DBConn *db=g_malloc(sizeof(_DBConn));

 if(!db) {
  fprintf(stderr, "Not enough memory to open another database !");
  return NULL;
 }

 db->c=NULL; 
 db->r=NULL;
 db->p=NULL;

 sprintf(connstr, "host='%s' dbname='%s' user='%s' password='%s'",
         prefs.db.host,
         prefs.db.database,
         prefs.db.user,
         prefs.db.password
	 );

 db->c= PQconnectdb(connstr);
 if(PQstatus(db->c) == CONNECTION_BAD) {
  fprintf(stderr,"DB: can't connect to database (%s)\n", connstr);
  g_free(db);
  return NULL;
 }

 if(-1 == db_exec((void *)db, "BEGIN"))
  return NULL; // Transactions unsupported ?

 return db;
}

// Returns the # of tuples or -1 on error
int db_exec(DBConn c, const char *q)
{
 _DBConn *db=(_DBConn *)c;

 if(!c) return -1;

 PQclear(db->r);
 db->r=PQexec(db->c, q);
 if(PQresultStatus(db->r) != PGRES_TUPLES_OK &&		// If returning tuples
    PQresultStatus(db->r) != PGRES_COMMAND_OK) {	// If returning nothing
  fprintf(stderr, "DB: error #%d (%s) in query '%s'\n",
          PQresultStatus(db->r), PQresultErrorMessage(db->r), q);
  return -1;
 }
 return PQntuples(db->r);
}

char *db_getrow(DBConn c, int row, int col)
{
 _DBConn *db=(_DBConn *)c;
 if(!c)
  return NULL;
 if(row<0 || row>=PQntuples(db->r))
  return NULL;
 if(col<0 || col>=PQnfields(db->r))
  return NULL;
 return PQgetvalue(db->r, row, col);
}

DBConn db_dup(DBConn conn)
{
 _DBConn *c=(_DBConn *)conn, *t=g_malloc(sizeof(_DBConn));
 t->c=c->c;
 t->r=NULL;
 t->p=c;
 return (DBConn)t;
}

// "escapes" special characters
// returned ptr must bu g_free'd
char *db_esc(char *str)
{
 char *tmp;
 int c1, c2;
 c1=c2=0;

 tmp=g_malloc(2*strlen(str)+1);
 while(str[c1]) {
  if(str[c1]=='\'' ||
     str[c1]=='\\'
    ) {
   tmp[c2++]='\\';
  }
  tmp[c2++]=str[c1];
  ++c1;
 }
 tmp[c2]=0;
 return tmp;
}

void db_undup(DBConn c)
{
 _DBConn *db=(_DBConn *)c;
 PQclear(db->r);
 g_free(c);
} 

void db_disconnect(DBConn c)
{
 _DBConn *db=(_DBConn *)c;
 if(c) {
  db->r=PQexec(db->c, "END");
  PQclear(db->r);
  PQfinish(db->c);
  g_free(c);
 }
}
