#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "globvars.h"
#include "utility.h"
#include "db.h"

void
on_search_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
 GtkWidget *s_resultlist=lookup_widget(diacatalog, "search_results"),
           *s_from=lookup_widget(diacatalog, "search_from"),
           *s_to=lookup_widget(diacatalog, "search_to"),
           *s_cave=lookup_widget(diacatalog, "search_cave"),
           *s_author=lookup_widget(diacatalog, "search_author"),
	   *s_quality=lookup_widget(diacatalog, "search_quality"),
           *s_keywords=lookup_widget(diacatalog, "search_keywords"),
           *s_andor=lookup_widget(diacatalog, "search_keyand");
 char query[2048], buff[256], *t, tmpdate[20], *tmp;
 gboolean s_keyandor=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(s_andor));
 int s_from_y,s_from_m,s_from_d, s_to_y, s_to_m, s_to_d;
 sprintf(tmpdate, "%s",
         gtk_entry_get_text(GTK_ENTRY(GNOME_DATE_EDIT(s_from)->date_entry)));
 sscanf(tmpdate, "%d/%d/%d", &s_from_m, &s_from_d, &s_from_y);
 sprintf(tmpdate, "%s",
         gtk_entry_get_text(GTK_ENTRY(GNOME_DATE_EDIT(s_to)->date_entry)));
 sscanf(tmpdate, "%d/%d/%d", &s_to_m, &s_to_d, &s_to_y);

 sprintf(query,
        "SELECT p.date, trim(c.name), trim(p.keywords), p.id, p.quality "
	"FROM photos p,authors a, caves c WHERE "
        "p.date>='%d-%d-%d' and p.date<='%d-%d-%d' and "
	"p.cave=c.id and p.author=a.id and ",
	s_from_y, s_from_m, s_from_d, s_to_y, s_to_m, s_to_d
	);

 strcpy(buff, gtk_entry_get_text(GTK_ENTRY(s_cave)));
 t=buff;
 if(strlen(t)) {
  tmp=db_esc(t);
  t=1+strrchr(t, '('); // I'm sure there's at least one
  strtok(t, ")"); // cut out the closing brace
  strcat(query, "c.cave='");
  strcat(query, tmp);
  strcat(query, "' and ");
  g_free(tmp);
 };

 t=gtk_entry_get_text(GTK_ENTRY(s_author));
 if(strlen(t)) {
  strcat(query, "trim(a.name)||' '||trim(a.surname)='");
  strcat(query, t);
  strcat(query, "' and ");
 };

 sprintf(buff, "p.quality<=%d and ",
         g_list_index(GTK_MENU_SHELL(GTK_OPTION_MENU(s_quality)->menu)->children,
    		      gtk_menu_get_active(
	    	       GTK_MENU(GTK_OPTION_MENU(s_quality)->menu)
	              )
	             )
        );
 strcat(query, buff);

 strcpy(buff, gtk_entry_get_text(GTK_ENTRY(s_keywords)));
 t=buff;
 if(strlen(t)) {
  strcat(query, "(");
  t=strtok(t, " ,\t\n");
  do {
   strcat(query, "(upper(p.keywords) LIKE upper('%");
   strcat(query, t);
   strcat(query, s_keyandor?"%')) and ":"%')) or ");
   t=strtok(NULL, " ,\t\n");
  } while(t);
  strcat(query, s_keyandor?"(true))":"(false))");
 } else {
  strcat(query, "true");
 };

 strcat(query, " ORDER BY p.quality");

 gtk_clist_clear(GTK_CLIST(s_resultlist));
 { // DB handling block
  DBConn conn;
  char *resstr[3];
  int nResults, cnt;

  conn=db_connect();
  nResults=db_exec(conn, query);
  activity();

  for(cnt=0; cnt<nResults; ++cnt) {
   resstr[0]=trim(db_getrow(conn, cnt, 0));
   resstr[1]=trim(db_getrow(conn, cnt, 1));
   resstr[2]=trim(db_getrow(conn, cnt, 2));
   gtk_clist_append(GTK_CLIST(s_resultlist), resstr);
   gtk_clist_set_row_data(GTK_CLIST(s_resultlist), cnt,
			  (gpointer)atoi(db_getrow(conn, cnt, 3)));
   gtk_clist_set_row_style(GTK_CLIST(s_resultlist), cnt,
			   search_results_style[atoi(db_getrow(conn, cnt, 4))]);
   activity();
  }
  db_disconnect(conn);
 }
 gtk_widget_show(s_resultlist);
}


void
on_search_cancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
 GtkWidget *s_resultlist=lookup_widget(diacatalog, "search_results"),
           *s_from=lookup_widget(diacatalog, "search_from"),
           *s_to=lookup_widget(diacatalog, "search_to"),
           *s_cave=lookup_widget(diacatalog, "search_cave_select"),
           *s_author=lookup_widget(diacatalog, "search_author"),
	   *s_quality=lookup_widget(diacatalog, "search_quality"),
           *s_keywords=lookup_widget(diacatalog, "search_keywords"),
           *s_andor=lookup_widget(diacatalog, "search_keyand");
 GList *empty=g_list_append(NULL, "");

 gnome_date_edit_set_time(GNOME_DATE_EDIT(s_from), 1);
 gnome_date_edit_set_time(GNOME_DATE_EDIT(s_to), 0);
 gtk_combo_set_popdown_strings(GTK_COMBO(s_cave), empty);
 gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(s_cave)->entry), "");
 gtk_entry_set_text(GTK_ENTRY(s_author), "");
 gtk_option_menu_set_history(GTK_OPTION_MENU(s_quality), RES_COLOR_LOW);
 gtk_entry_set_text(GTK_ENTRY(s_keywords), "");
 gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(s_andor), TRUE);
 gtk_clist_clear(GTK_CLIST(s_resultlist));
}

void
on_search_results_select_row        (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
 GtkWidget *p_date=lookup_widget(diacatalog, "properties_date"),
           *p_cave=lookup_widget(diacatalog, "properties_cave"),
           *p_auth=lookup_widget(diacatalog, "properties_author"),
           *p_kwrd=lookup_widget(diacatalog, "properties_keywords"),
           *p_desc=lookup_widget(diacatalog, "properties_descr"),
           *p_file=lookup_widget(diacatalog, "properties_file"),
           *p_fsiz=lookup_widget(diacatalog, "properties_filesize");
 DBConn c=db_connect();
 char query[1024];

 current_preview.id=(gint)gtk_clist_get_row_data(clist, row);
 sprintf(query, "SELECT p.date, trim(c.name)||' ('||trim(c.cave)||')', "
                "trim(a.name)||' '||trim(a.surname), p.quality, "
		"trim(p.keywords), p.descr, trim(p.filename), "
		"p.filesize FROM photos p, authors a, caves c "
		"WHERE c.id=p.cave and a.id=p.author and p.id=%d",
		current_preview.id);

 db_exec(c, query);

 strcpy(current_preview.filename, db_getrow(c, 0, 6));
 current_preview.filesize= atoi(db_getrow(c, 0, 7));

 gtk_entry_set_text(GTK_ENTRY(p_date), db_getrow(c, 0, 0));
 gtk_entry_set_text(GTK_ENTRY(p_cave), db_getrow(c, 0, 1));
 gtk_entry_set_text(GTK_ENTRY(p_auth), db_getrow(c, 0, 2));
 gtk_widget_set_style(p_cave, search_results_style[atoi(db_getrow(c, 0, 3))]);
 gtk_entry_set_text(GTK_ENTRY(p_kwrd), db_getrow(c, 0, 4));
 gtk_text_freeze(GTK_TEXT(p_desc));
 gtk_text_set_word_wrap(GTK_TEXT(p_desc), TRUE);
 gtk_text_set_point(GTK_TEXT(p_desc), 0);
 gtk_text_forward_delete(GTK_TEXT(p_desc), gtk_text_get_length(GTK_TEXT(p_desc)));
 gtk_text_insert(GTK_TEXT(p_desc), NULL, NULL, NULL, db_getrow(c, 0, 5), -1);
 gtk_text_thaw(GTK_TEXT(p_desc));
 gtk_entry_set_text(GTK_ENTRY(p_file), current_preview.filename);
 gtk_entry_set_text(GTK_ENTRY(p_fsiz), db_getrow(c, 0, 7));
 sprintf(query, "%s/%s", prefs.dirs.thumbs, db_getrow(c, 0, 6));
 { // Check that file actually exists
  struct stat f;
  if(stat(query, &f)) {
   char *t=gnome_pixmap_file("diacat/nothumb.png");
   strcpy(query, t);
   g_free(t);
  }
 }
 gnome_pixmap_load_file(GNOME_PIXMAP(lw(diacatalog, "preview")),
                        query);
 db_disconnect(c);
}
