#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "globvars.h"
#include "utility.h"
#include "db.h"

// Used to interrupt long ops
//static gboolean cancel_op=FALSE;

// Store last 'OK'ed value in locselect
static int lastlocid=0;

void
on_insert_new_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_show(newcave);
}


void
on_insert_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
 GtkWidget *i_date=lw(diacatalog, "insert_date"),
           *i_cave=lw(diacatalog, "insert_cave"),
           *i_auth=lw(diacatalog, "insert_author"),
           *i_qual=lw(diacatalog, "insert_quality"),
           *i_kwrd=lw(diacatalog, "insert_keywords"),
           *i_desc=lw(diacatalog, "insert_descr"),
           *i_file=lw(diacatalog, "insert_filename"),
	   *menu=GTK_OPTION_MENU(i_qual)->menu,
	   *active_item=gtk_menu_get_active(GTK_MENU(menu));
 int active_index=g_list_index(GTK_MENU_SHELL(menu)->children, active_item);
 char query[1024];
 gchar *descr=db_esc(gtk_editable_get_chars(GTK_EDITABLE(i_desc), 0, -1)),
       *fname=db_esc(gtk_entry_get_text(GTK_ENTRY(i_file))),
       *kwrd=db_esc(gtk_entry_get_text(GTK_ENTRY(i_kwrd))),
       *cave=db_esc(gtk_entry_get_text(GTK_ENTRY(i_cave))),
       *auth=db_esc(gtk_entry_get_text(GTK_ENTRY(i_auth)));
 DBConn c=db_connect();
 struct stat statbuff;

 if(!stat(fname, &statbuff)) {
  sprintf(query, "INSERT INTO photos (date, cave, author, quality, keywords, "
                 "descr, filename, filesize) "
                 "SELECT '%s', c.id, a.id, %d, '%s', '%s', '%s', %d "
		 "FROM caves c, authors a "
		 "WHERE trim(c.name)||' ('||trim(c.cave)||')'= '%s' and "
		 "trim(a.name)||' '||trim(a.surname)='%s'",
          gtk_entry_get_text(GTK_ENTRY(GNOME_DATE_EDIT(i_date)->date_entry)),
	  active_index,
          kwrd,
	  descr,
          fname,
	  (int)statbuff.st_size,
          cave,
          auth
	 );

  g_free(descr);
  g_free(fname);
  g_free(kwrd);
  g_free(cave);
  g_free(auth);
  if(!db_exec(c, query)) {
   gtk_entry_set_text(GTK_ENTRY(i_kwrd), "");
   gtk_text_freeze(GTK_TEXT(i_desc));
   gtk_text_set_point(GTK_TEXT(i_desc), 0);
   gtk_text_forward_delete(GTK_TEXT(i_desc),
                           gtk_text_get_length(GTK_TEXT(i_desc)));
   gtk_text_thaw(GTK_TEXT(i_desc));
   gtk_entry_set_text(GTK_ENTRY(i_file), "");
   gnome_appbar_set_status(appbar, "");
  } else {
   gnome_appbar_set_status(appbar, _("Errore in fase di inserimento (file gia'"
			   " catalogato ?)"));
  }
 }

 db_disconnect(c);
}


void
on_insert_cancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
 GtkWidget // *i_date=lw(diacatalog, "insert_date"),
           *i_kwrd=lw(diacatalog, "insert_keywords"),
           *i_desc=lw(diacatalog, "insert_descr"),
           *i_file=lw(diacatalog, "insert_filename");
 gtk_entry_set_text(GTK_ENTRY(i_kwrd), "");
 gtk_text_freeze(GTK_TEXT(i_desc));
 gtk_text_set_point(GTK_TEXT(i_desc), 0);
 gtk_text_forward_delete(GTK_TEXT(i_desc),
                         gtk_text_get_length(GTK_TEXT(i_desc)));
 gtk_text_thaw(GTK_TEXT(i_desc));
 gtk_entry_set_text(GTK_ENTRY(i_file), "");
 gnome_appbar_set_status(appbar, "");
}


void
on_scanbutton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}

// Newcave
void
on_newcave_newloc_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_show(newloc);
}

// Used by on_newcave_{ok|apply}_clicked
static int 
newcave_db_insert(void)
{
 int r;
 DBConn c=db_connect();
 char query[1024],
      *cave=db_esc(gtk_entry_get_text(GTK_ENTRY(lw(newcave, "newcave_cave")))),
      *name=db_esc(gtk_entry_get_text(GTK_ENTRY(lw(newcave, "newcave_name")))),
      *loc=db_esc(gtk_entry_get_text(GTK_ENTRY(lw(newcave, "newcave_loc"))));
 sprintf(query,
         "INSERT INTO caves (cave, name, location) "
	  "SELECT '%s', '%s', l.id FROM locations l "
	  "WHERE trim(l.descr)=trim('%s')",
	 cave,
	 name,
	 trim(loc));
 g_free(cave);
 g_free(name);
 g_free(loc);

 r=db_exec(c, query);
 db_disconnect(c);
 return r;
}

void
on_newcave_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!newcave_db_insert()) {
  char *t=gtk_entry_get_text(GTK_ENTRY(lw(newcave, "newcave_name"))),
       *c=gtk_entry_get_text(GTK_ENTRY(lw(newcave, "newcave_cave")));
  GtkCombo *combo=GTK_COMBO(lw(diacatalog, "insert_cave_select"));
  GList *l;
  char buff[256];

  sprintf(buff, "%s (%s)", trim(t), trim(c));
  l=g_list_append(NULL, buff);
  gtk_combo_set_popdown_strings(combo, l);
  gtk_entry_set_text(GTK_ENTRY(combo->entry), buff);
  gtk_widget_hide(newcave);
 }
}


void
on_newcave_apply_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!newcave_db_insert()) {
  gtk_entry_set_text(GTK_ENTRY(lw(newcave, "newcave_cave")), "");
  gtk_entry_set_text(GTK_ENTRY(lw(newcave, "newcave_name")), "");
 }
}


void
on_newcave_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_hide(newcave);
}

void
on_loc_browse_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
 switch((gint)user_data) {
  case 0:
	  browse_result=lw(newcave, "newcave_loc");
	  break;
  case 1:
	  browse_result=lw(newloc, "newloc_parent");
	  break;
 }
 locsel_tree_init((gint)user_data);
 gtk_widget_show(locselect);
}

// used by on_newloc_{ok|apply}_clicked
// Returns 0 when OK, -1 on error
static int
newloc_db_insert(void)
{
 int r;
 DBConn c=db_connect();
 char query[256],
      *desc=db_esc(gtk_entry_get_text(GTK_ENTRY(lw(newloc, "newloc_descr"))));

 sprintf(query, "INSERT INTO locations (parent, descr) VALUES (%d, '%s')",
         lastlocid,
	 desc);
 g_free(desc);
 r=db_exec(c, query);
 db_disconnect(c);

 return r;
}

void
on_newloc_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!newloc_db_insert()) {
  gtk_entry_set_text(GTK_ENTRY(lw(newcave, "newcave_loc")), 
                     gtk_entry_get_text(GTK_ENTRY(
		         lw(newloc, "newloc_descr"))));
  gtk_widget_hide(newloc);
 }
}

void
on_newloc_apply_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
 GtkWidget *descr=lw(newloc, "newloc_descr");
 if(!newloc_db_insert()) {
  gtk_entry_set_text(GTK_ENTRY(descr), "");
  gtk_widget_grab_focus(descr);
 }
}


void
on_newloc_cancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_hide(newloc);
}

void
on_locselect_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
 DBConn c=db_connect();
 gchar query[256];
 
 sprintf(query, "SELECT descr FROM locations WHERE id=%d", cavesel.rowcode);
 db_exec(c, query);
 gtk_entry_set_text(GTK_ENTRY(browse_result), db_getrow(c, 0, 0));
 /* cavesel.rowcode DOESN'T remain valid !!!
 // (after pressing OK, the user could press browse again, select another row,
 // press cancel and the value is wrong !)
 */
 lastlocid=cavesel.rowcode;

 db_disconnect(c);
}


void
on_insert_author_new_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_show(newauthor);
}

// Used by on_newauthor_{ok|apply}_clicked
static int
newauthor_db_insert(int update_text)
{
 int r;
 GtkEntry *surname=GTK_ENTRY(lw(newauthor, "newauthor_surname")),
	  *name=GTK_ENTRY(lw(newauthor, "newauthor_name"));
 DBConn c=db_connect();
 char query[256],
      *sn=db_esc(gtk_entry_get_text(surname)),
      *n=db_esc(gtk_entry_get_text(name));
 sprintf(query, "INSERT INTO authors (surname, name) VALUES ('%s', '%s')",
	 sn,
	 n);

 g_free(sn);
 g_free(n);

 r=db_exec(c, query);

 if(-1!=r) {
  GtkCombo *combo;
  sprintf(query, "%s %s",
          trim(gtk_entry_get_text(name)),
	  trim(gtk_entry_get_text(surname)));

  combo=GTK_COMBO(lw(diacatalog, "search_author_select"));
  combo_string_add(combo, query);
  combo=GTK_COMBO(lw(newcd, "newcd_author_select"));
  combo_string_add(combo, query);
  combo=GTK_COMBO(lw(diacatalog, "insert_author_select"));
  combo_string_add(combo, query);
  if(update_text) { // needs combo pointing to insert_author_select !!!
   gtk_entry_set_text(GTK_ENTRY(combo->entry), query);
  }

  gtk_entry_set_text(surname, "");
  gtk_entry_set_text(name, "");
 }

 db_disconnect(c);
 return r;
}

void
on_newauthor_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!newauthor_db_insert(1)) {
  gtk_widget_hide(newauthor);
 }
}


void
on_newauthor_apply_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
 newauthor_db_insert(0);
}


void
on_newauthor_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_hide(newauthor);
}
