#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "globvars.h"
#include "utility.h"
#include "db.h"

void
update_stats                           (GtkWidget       *widget,
                                        gpointer         user_data)
{
 DBConn c=db_connect();
 if(c) {
  char buff[80];
  GtkWidget *w;
  {
   FILE *mi=fopen("/proc/meminfo", "r");
   char buff[80];
   int tot=0, used=0, free=0, shared=0, buffers=0, cached=0;
   fgets(buff, 80, mi); fgets(buff, 80, mi);
   fclose(mi);
   sscanf(buff, "%*s %d %d %d %d %d %d",
          &tot, &used, &free, &shared, &buffers, &cached);
   free=tot-used+buffers+cached;
   w=lw(diacatalog, "info_freemem");
   gtk_progress_configure(GTK_PROGRESS(w),
                          free/(1024*1024), 0, tot/(1024*1024));
  }

//@@@ How do I get free disk space ???
//  w=lw(diacatalog, "info_freedisk");
//  gtk_entry_set_text(GTK_ENTRY(w), "2");

  if(1==db_exec(c, "SELECT count(*) FROM photos")) {
   sprintf(buff, "%s", db_getrow(c, 0, 0) );
   w=lw(diacatalog, "info_imgno");
   if(atoi(buff)) {
    db_exec(c, "SELECT sum(filesize) FROM photos");
    strcat(buff, " [");
    strcat(buff, db_getrow(c, 0, 0));
    strcat(buff, " bytes]");
    gtk_entry_set_text(GTK_ENTRY(w), buff);
   } else
    gtk_entry_set_text(GTK_ENTRY(w), _("Nessuna immagine in archivio"));
  };

  if(1==db_exec(c, "SELECT COUNT(*) FROM cds")) {
   sprintf(buff, "%s", db_getrow(c, 0, 0));
   if(strcmp(buff, "0")) {
    w=lw(diacatalog, "info_cdno");
    gtk_entry_set_text(GTK_ENTRY(w), buff);
   }
  };
 };
 db_disconnect(c);
}
