#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "globvars.h"
#include "utility.h"
#include "db.h"

// Store last CD selected
static int lastcd=-1;

// Last file selected (row# and associated ptr)
static int cdrow=0;
static gpointer cddata=NULL;

// # of files on CD (used by "move to bottom")
static int nfiles=0;

// CList of CD files
static GtkCList *files=NULL;

static void newcd_clean_fields(void)
{
 gtk_entry_set_text(GTK_ENTRY(lw(newcd, "newcd_cdid")), "");
 gtk_entry_set_text(GTK_ENTRY(lw(newcd, "newcd_comment")), "");
 gtk_entry_set_text(GTK_ENTRY(lw(newcd, "newcd_author")), "");
}

void
on_createcd_cdid_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
 DBConn c=db_connect();
 char query[256], *id=db_esc(trim(gtk_entry_get_text(GTK_ENTRY(editable))));

 sprintf(query, "SELECT cd.id, cd.comment, "
		"trim(auth.name)||' '||trim(auth.surname), closed "
		"FROM cds cd, authors auth WHERE auth.id=cd.preparer "
		"and trim(cd.cdid)='%s'", id);
 g_free(id);
 if(1==db_exec(c, query)) {
  int cnt;
  char *row[2];
  if(!files)
   files=GTK_CLIST(lw(diacatalog, "createcd_files"));
  lastcd=atoi(db_getrow(c, 0, 0));
  gtk_entry_set_text(GTK_ENTRY(lw(diacatalog, "createcd_comment")),
                     db_getrow(c, 0, 1));
  gtk_entry_set_text(GTK_ENTRY(lw(diacatalog, "createcd_preparer")),
                     db_getrow(c, 0, 2));
  // Update createcd_size !
  sprintf(query, "SELECT sum(p.filesize) FROM cdfiles f, cds c, photos p "
        	 "WHERE c.id=f.cdid and p.cave=f.photoid and trim(c.cdid)='%s'",
		 db_esc(trim(gtk_entry_get_text(GTK_ENTRY(editable)))));
  db_exec(c, query);
  gtk_progress_set_value(GTK_PROGRESS(
			  lw(diacatalog, "createcd_size")),
			 atoi(db_getrow(c, 0, 0))/(1024*1024));
  sprintf(query, "SELECT trim(p.filename), p.filesize "
                 "FROM photos p, cds c, cdfiles f "
		 "WHERE c.id=f.cdid and p.id=f.photoid and "
		 "trim(c.cdid)='%s'",
		 db_esc(trim(gtk_entry_get_text(GTK_ENTRY(editable)))));
  nfiles=db_exec(c, query);
    gtk_clist_freeze(files);
  gtk_clist_clear(files);
  for(cnt=0; cnt<nfiles; ++cnt) {
   row[0]=db_getrow(c, cnt, 0);
   row[1]=db_getrow(c, cnt, 1);
   gtk_clist_append(files, row);
   activity();
  }
  gtk_clist_thaw(files);
 }
 db_disconnect(c);
}

void
on_newcdbutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_show(newcd);
}


void
on_createcd_files_select_row           (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
 cdrow=row;
 cddata=user_data;
}

void
on_createcd_write_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}

void
on_createcd_test_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}

// CreateCD Toolbar ops
void
on_createcd_files_top_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!files)
  files=GTK_CLIST(lw(diacatalog, "createcd_files"));
 gtk_clist_row_move(files, cdrow, 0);
 cdrow=0;
}

void
on_createcd_files_move_up_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!files)
  files=GTK_CLIST(lw(diacatalog, "createcd_files"));
 if(cdrow>0) {
  gtk_clist_swap_rows(files, cdrow, cdrow-1);
  --cdrow;
 }
}


void
on_createcd_files_view_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}

void
on_createcd_files_move_down_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!files)
  files=GTK_CLIST(lw(diacatalog, "createcd_files"));
 if(cdrow>-1 && cdrow<(nfiles-1)) {
  gtk_clist_swap_rows(files, cdrow, cdrow+1);
  ++cdrow;
 }
}

void
on_createcd_files_bottom_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
 if(!files)
  files=GTK_CLIST(lw(diacatalog, "createcd_files"));
 gtk_clist_row_move(files, cdrow, nfiles-1);
 cdrow=nfiles-1;
}

void
on_createcd_files_add_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}

void
on_createcd_files_remove_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}

void
on_createcd_files_clear_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
 if(-1!=lastcd)
  gtk_widget_show(confirm_delete_all);
}

void
on_confirm_delete_all_ok_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
 DBConn c=db_connect();
 char query[256];
 if(!files)
  files=GTK_CLIST(lw(diacatalog, "createcd_files"));

 sprintf(query, "DELETE FROM cdfiles WHERE cdid=%d", lastcd);
 if(-1!=db_exec(c, query)) {
  gtk_clist_clear(files);
 };

 db_disconnect(c);
}

void
on_confirm_delete_all_cancel_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
 // Do nothing
}


/* Newcd window */
void
on_newcd_ok_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
 DBConn c=db_connect();
 char query[1024], *id, *cmt, *author;

 /* Update fields in main window */
 GtkWidget *cdid_l, *cdid_g;	// Local and global CD-IDs

 cdid_l = lw(newcd, "newcd_cdid");
 cdid_g = lw(diacatalog, "createcd_cdid");

 id=db_esc(gtk_entry_get_text(GTK_ENTRY(cdid_l)));
 cmt=db_esc(gtk_entry_get_text(GTK_ENTRY(lw(newcd, "newcd_comment"))));
 author=db_esc(gtk_entry_get_text(GTK_ENTRY(lw(newcd, "newcd_author"))));
 // Add to database all the new info
 sprintf(query, "INSERT INTO cds (cdid, comment, preparer, closed) "
                "SELECT '%s', '%s', id, 'f' FROM authors WHERE "
		"trim(name)||' '||trim(surname)='%s'", id, cmt, author);

 if(-1!=db_exec(c, query))
 {
  // This updates main window entries
  gtk_entry_set_text(GTK_ENTRY(cdid_g),
                     gtk_entry_get_text(GTK_ENTRY(cdid_l)));

  newcd_clean_fields();
  gtk_widget_hide(newcd);

  update_cds(GTK_COMBO(lw(diacatalog, "createcd_cdid_select")));
 }

 g_free(id);
 g_free(cmt);
 g_free(author);

 db_disconnect(c);
}

void
on_newcd_cancel_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
 /* Just clean & hide widget */
 newcd_clean_fields();
 gtk_widget_hide(newcd);
}

void
on_createcd_map                        (GtkWidget       *widget,
                                        gpointer         user_data)
{
 update_cds(GTK_COMBO(lw(diacatalog, "createcd_cdid_select")));
}

/*************************************************************************/
/* "Preview" button */
gboolean
on_preview_button_clicked              (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
 int row;
 if(!files)
  files=GTK_CLIST(lw(diacatalog, "createcd_files"));

 if(-1==lastcd)
  gtk_widget_show(create_no_cd());

 row=gtk_clist_find_row_from_data(files, (gpointer)current_preview.id);
 if((-1!=lastcd) && current_preview.filesize && (-1 == row)) {
  DBConn c;
  char buff[12], *line[2]={current_preview.filename, buff}, query[256];
  sprintf(buff, "%d", current_preview.filesize);
  row=gtk_clist_append(files, line);
  gtk_clist_set_row_data(files, row, (gpointer)current_preview.id);
  ++nfiles;

  sprintf(query, "INSERT INTO cdfiles (cdid, photoid) VALUES (%d, %d)",
          lastcd, current_preview.id);
  // Add to the database
  c=db_connect();
  db_exec(c, query);	// @@@ Should check...
  db_disconnect(c);
 }
 return FALSE;
}

