#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "globvars.h"
#include "utility.h"
#include "db.h"

// Used to interrupt long ops
static gboolean cancel_op=FALSE;

/*************************************************************************/
/* Main menu */

void
on_new_file_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_open_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_save_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_save_as_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_exit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 gtk_main_quit();
}


void
on_cut_activate                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_copy_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_paste_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_menu_clear_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 DBG();
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 gtk_widget_show(preferences);
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 gtk_widget_show(create_about());
}


/*************************************************************************/
/* Toolbar */
void
on_button_preferences_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_show(preferences);
}

/*************************************************************************/
/* CAVE select window */
void
on_cavesel_sort_changed                (GtkMenuShell    *menu,
                                        gpointer         user_data)
{
 cavesel.ord=g_list_index(menu->children, gtk_menu_get_active(GTK_MENU(menu)));
 cavesel.rowcode=0;

 cavesel_tree_init(cavesel.ord);
}

void
on_locselect_tree_select_row           (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
 cavesel.rowcode=(int)gtk_ctree_node_get_row_data(ctree,GTK_CTREE_NODE(node));
}

void
on_cavesel_tree_select_row             (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
 cavesel.rowcode=(int)gtk_ctree_node_get_row_data(ctree,GTK_CTREE_NODE(node));
}

void
on_cavesel_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
 int cnt;
 DBConn conn;
 GList *menu=NULL;
 gchar query[1024];
 int nrows;

 conn=db_connect();
 switch(cavesel.ord) {
  case CAVESEL_ORD_NAME:
    sprintf(query, "SELECT cave, name FROM caves WHERE id=%d",
		    cavesel.rowcode);
    break;

  case CAVESEL_ORD_LOC:
    sprintf(query, "SELECT c.cave, c.name FROM caves c, locations l WHERE "
		   "c.location=l.id and l.id=%d ORDER BY c.name",
		   cavesel.rowcode);
    break;
 };

 nrows=db_exec(conn, query);

 for(cnt=0; cnt<nrows; ++cnt) {
  char buff[80], *t1, *t2;
  t1=db_esc(trim(db_getrow(conn, cnt, 1)));
  t2=db_esc(trim(db_getrow(conn, cnt, 0)));
  sprintf(buff, "%s (%s)", t1, t2);
  menu=g_list_append(menu, strdup(buff));
  g_free(t1); g_free(t2);
 }

 menu=g_list_sort(menu, (GCompareFunc)strcmp);

 db_disconnect(conn);

 if(menu) {
  gtk_combo_set_popdown_strings(GTK_COMBO(browse_result), menu);
  gtk_combo_set_value_in_list(GTK_COMBO(browse_result), TRUE, FALSE);
  gtk_widget_hide(caveselect);
 };
}


void
on_cavesel_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
 // Just hide
 gtk_widget_hide(caveselect);
}


/*************************************************************************/
/* Preferences window */
void
on_prefs_db_backup_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}


void
on_prefs_db_restore_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
 DBG();
}

void
on_prefs_ok_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
 Prefs *p=test_prefs();
 DBConn conn=db_connect();

 if(conn) {
  db_disconnect(conn);
  save_prefs(); //@@@ should check return value
  gtk_widget_hide(preferences);
 } else {
  cancel_prefs(p);
 };
}


void
on_prefs_apply_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
 apply_prefs();
 gtk_widget_hide(preferences);
}


void
on_prefs_cancel_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
 restore_prefs();
 gtk_widget_hide(preferences);
}


void
on_cave_browse_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
 char *widgets[]={"search_cave_select",
                  "insert_cave_select"};

 browse_result=lw(diacatalog, widgets[(gint)user_data]);
 cavesel_tree_init(cavesel.ord);
 gtk_widget_show(caveselect);
}

void
on_prefs_db_create_new_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
 gtk_widget_show(confirm_init_db);
}

void
on_confirm_init_db_yes_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
 // Tablename, fields def, initializer, constraints
 char *tables[][3]= { // table, fielsd, autoinsert
  { "authors", "id SERIAL PRIMARY KEY, "
               "surname character(30) NOT NULL, "
	       "name character(20) NOT NULL, "
	       "UNIQUE (surname, name)",
	       _("0, 'Sconosciuto', 'Autore' ")
	       },
  { "locations", "id SERIAL PRIMARY KEY,"
               "parent int4 NOT NULL REFERENCES locations,"
               "descr character(40) NOT NULL UNIQUE",
	       _("0, 0, 'Tutto il mondo'")
	       },
  { "caves", "id SERIAL PRIMARY KEY,"
               "cave character(20) NOT NULL UNIQUE,"
               "name character(60) NOT NULL UNIQUE,"
               "location int4 REFERENCES locations",
	       NULL
	       },
  { "cds", "id SERIAL PRIMARY KEY,"
               "cdid character(14) NOT NULL UNIQUE, "
               "comment text, "
               "preparer int4 REFERENCES authors, "
               "closed boolean",
	       NULL
	       },
  { "photos", "id SERIAL PRIMARY KEY,"
               "date date NOT NULL,"
               "cave int4 NOT NULL REFERENCES caves,"
               "author int4 NOT NULL REFERENCES authors,"
               "quality int2 NOT NULL,"
               "keywords text NOT NULL,"
               "descr text,"
               "filename character(128) NOT NULL UNIQUE,"
               "filesize int4 NOT NULL",
	       NULL
	       },
  { "cdfiles", "cdid int4 REFERENCES cds,"
               "photoid int4 REFERENCES photos, "
	       "UNIQUE (cdid, photoid)",
	       NULL
	       },
  { NULL, NULL, NULL }
 };
 char buff[2048];
 int cnt=0;
 DBConn c;
 GtkProgress *pb=GTK_PROGRESS(lw(createdb_info, "createdb_progress"));
 GtkEntry *op=GTK_ENTRY(lw(createdb_info, "createdb_info_op"));
 #define TABLES (sizeof(tables)/sizeof(tables[0]))
 // In STEPS : connect, create tables, insert values, commit, disconnect
 #define STEPS (1+TABLES+TABLES+1+1)

 cancel_op=FALSE;

 gtk_widget_show_now(createdb_info);
 activity();

 gtk_progress_set_percentage(pb, 0);
 gtk_entry_set_text(op, _("Creazione database"));
 activity();

 { // Completly destroy database
  Prefs *savep=test_prefs();
  char *t;
  strcpy(prefs.db.database, "template1");	// PostgreSQL specific !
  c=db_connect();
  db_exec(c, "commit");
  t=db_esc(savep->db.database);
  sprintf(buff, "DROP DATABASE %s", t);
  db_exec(c, buff);
  g_free(t); t=db_esc(savep->db.database);
  sprintf(buff, "CREATE DATABASE %s", t);
  db_exec(c, buff);
  db_disconnect(c);
  g_free(t);
  cancel_prefs(savep);
 }
 c=db_connect();

 cnt=0;
 while(!cancel_op && tables[cnt][0]) {
  sprintf(buff, _("Creazione tabella %s"), tables[cnt][0]);
  gtk_progress_set_percentage(pb, (1+(cnt<<1))*(1./STEPS));
  gtk_entry_set_text(op, buff);
  activity();
  sprintf(buff, "CREATE TABLE %s (%s)", tables[cnt][0], tables[cnt][1]);
  if(-1==db_exec(c, buff)) {
   cancel_op=TRUE;
  } else {
   sprintf(buff, _("Inserimento valori tabella %s"), tables[cnt][0]);
   gtk_progress_set_percentage(pb, (1+(cnt<<1)+1)*(1./STEPS));
   gtk_entry_set_text(op, buff);
   activity();
   if(tables[cnt][2]) {
    sprintf(buff, "INSERT INTO %s VALUES (%s)", tables[cnt][0], tables[cnt][2]);
    if(-1==db_exec(c, buff)) {
     cancel_op=TRUE;
    }
   }
  }
  ++cnt;
 };

 sprintf(buff, _("Conferma inserimenti"));
 gtk_progress_set_percentage(pb, (1+(TABLES<<1)+1)*(1./STEPS));
 gtk_entry_set_text(op, buff);
 activity();
 db_exec(c,"commit");

 #undef TABLES
 #undef STEPS
 gtk_widget_hide(createdb_info);

 db_exec(c, "begin");
 db_disconnect(c);
}

/*************************************************************************/
